import { NextResponse } from "next/server";
import { OperationalAnalytics } from "@/lib/operational-analytics";

export async function GET() {
  try {
    console.log("[OPERATIONS_API] Getting operational efficiency metrics...");

    const metrics = await OperationalAnalytics.getOperationalMetrics();

    const response = {
      success: true,
      metrics: {
        // Turnover & Leasing
        turnover_rate_12mo: metrics.turnoverRate12Mo,
        avg_make_ready_days: metrics.avgMakeReadyDays,
        avg_lease_up_days: metrics.avgLeaseUpDays,

        // Maintenance & Work Orders
        work_order_backlog: metrics.workOrderBacklog,
        avg_work_order_age: metrics.avgWorkOrderAge,
        sla_compliance: metrics.slaCompliance,
        first_pass_fix_rate: metrics.firstPassFixRate,
        preventive_maintenance_compliance:
          metrics.preventiveMaintenanceCompliance,
        maintenance_linked_vacancy_days: metrics.maintenanceLinkedVacancyDays,

        // Financial / Operational Intensity
        avg_turn_cost_per_unit: metrics.avgTurnCostPerUnit,
        work_orders_per_occupied_unit_30d: metrics.workOrdersPerOccupiedUnit30d,

        // Metadata
        snapshot_date: metrics.snapshotDate,
        total_occupied_units: metrics.totalOccupiedUnits,
        calculated_at: metrics.calculatedAt,
      },
    };

    console.log("[OPERATIONS_API] ✅ Returning operational metrics");
    return NextResponse.json(response);
  } catch (error) {
    console.error(
      "[OPERATIONS_API] ❌ Error getting operational metrics:",
      error,
    );
    return NextResponse.json(
      {
        success: false,
        error: error instanceof Error ? error.message : "Unknown error",
        metrics: null,
      },
      { status: 500 },
    );
  }
}
